package ohd.hseb.hefs.utils.tools;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;

public abstract class ResourceTools
{

    /**
     * @param packageName Name of package in a directory format; i.e., using slashes, not dots.
     * @return A set of files reflecting resources on the class path within the given package name.
     */
    public static Set<File> loadResourceContentsRecursively(final String packageName)
    {
        final URL url = ResourceTools.class.getResource(packageName);
        if(url == null)
        {
            throw new IllegalArgumentException("Unable to find resource by name '" + packageName + "'");
        }
        else
        {
            File dir;
            try
            {
                dir = new File(url.toURI());
                if(!dir.isDirectory() || !dir.canRead())
                {
                    throw new IllegalArgumentException("Found resource by name '" + packageName
                        + "', but it is either not a directory or cannot be read.");
                }
                return FileTools.listFilesRecursively(dir);
            }
            catch(final URISyntaxException e)
            {
                throw new IllegalStateException("Unable to convert URL to URI for resource '" + packageName + "'.", e);
            }

        }
    }
}
