package ohd.hseb.hefs.utils.tools;

import static com.google.common.collect.Sets.newHashSet;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;

public abstract class SetTools
{
    public static <E> LinkedHashSet<E> newLinkedHashSet(E... elements)
    {
        LinkedHashSet<E> set = Sets.newLinkedHashSet();
        for(E element: elements)
        {
            set.add(element);
        }
        return set;
    }

    /**
     * Returns a view of the union of the given sets. Performs better if the smaller sets are given first.
     */
    public static <E> Sets.SetView<E> viewOfSetUnion(Set<? extends E>... sets)
    {
        if(sets.length == 0)
        {
            Set<E> emptySet = Sets.newHashSet();
            return Sets.union(emptySet, emptySet);
        }
        else if(sets.length == 1)
        {
            Set<E> emptySet = Sets.newHashSet();
            return Sets.union(emptySet, sets[0]);
        }

        Sets.SetView<E> view = Sets.union(sets[sets.length - 2], sets[sets.length - 1]);
        for(int i = sets.length - 3; i >= 0; i--)
        {
            view = Sets.union(sets[i], view);
        }
        return view;
    }

    /**
     * Creates a new {@link HashSet} containing every element that was in each of the {@code items}.
     * 
     * @param items a group of items to create the intersection for
     */
    public static <E> HashSet<E> hashSetIntersection(Iterable<? extends E>... items)
    {
        HashSet<E> set = newHashSet();
        if(items.length == 0)
        {
            return set;
        }

        Iterables.addAll(set, items[0]);
        for(int i = 1; i < items.length; i++)
        {
            Iterator<E> setIterator = set.iterator();
            while(setIterator.hasNext())
            {
                if(!Iterables.contains(items[i], setIterator.next()))
                {
                    setIterator.remove();
                }
            }
        }

        return set;
    }
}
