package ohd.hseb.hefs.utils.tools;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;

import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;

public abstract class StreamTools
{

    /**
     * This method will close anything closeable, thowing away exceptions and checking for null before trying. This is
     * useful if you don't what an IOException to be thrown when closing.
     * 
     * @param toClose The item to close, such as InputStream and OutputStream. Null is allowed and results in nothing
     *            being done.
     */
    public static void closeStream(final Closeable toClose)
    {
        try
        {
            if(toClose != null)
            {
                toClose.close();
            }
        }
        catch(final Exception e)
        {

        }
    }

    /**
     * @param output {@link OutputStream} to encrypt.
     * @param encryptionKeyPhrase Key phrase to use.
     * @return An output stream with an AES encryption setup using {@link Cipher} and based on the encryption key
     *         passphrase provided. If null is provided, the output stream provided is returned without change.
     */
    public static OutputStream encryptOutputStream(final OutputStream output, final String encryptionKeyPhrase)
    {
        if(encryptionKeyPhrase != null)
        {
            try
            {
                final MessageDigest digest = MessageDigest.getInstance("SHA");
                digest.update(encryptionKeyPhrase.getBytes());
                final SecretKeySpec key = new SecretKeySpec(digest.digest(), 0, 16, "AES");

                final Cipher aesCipher = Cipher.getInstance("AES", "SunJCE");
                aesCipher.init(Cipher.ENCRYPT_MODE, key);
                final CipherOutputStream cipherOutput = new CipherOutputStream(output, aesCipher);
                return cipherOutput;
            }
            catch(final Exception e)
            {
                System.err.println("Unable to wrap output stream provided in a encrypter: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return output;
    }

    /**
     * @param intput {@link InputStream} to de-encrypt.
     * @param encryptionKeyPhrase Key phrase to use.
     * @return An input stream with an AES encryption setup using {@link Cipher} and based on the encryption key
     *         passphrase provided. If null is provided the input stream provided is returned without change.
     */
    public static InputStream encryptInputStream(final InputStream input, final String encryptionKeyPhrase)
    {
        if(encryptionKeyPhrase != null)
        {
            try
            {
                final MessageDigest digest = MessageDigest.getInstance("SHA");
                digest.update(encryptionKeyPhrase.getBytes());
                final SecretKeySpec key = new SecretKeySpec(digest.digest(), 0, 16, "AES");

                final Cipher aesCipher = Cipher.getInstance("AES", "SunJCE");
                aesCipher.init(Cipher.DECRYPT_MODE, key);
                final CipherInputStream cipherStream = new CipherInputStream(input, aesCipher);

                return cipherStream;
            }
            catch(final Exception e)
            {
                System.err.println("Unable to wrap input stream provided in a de-encrypter: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return input;
    }
}
