package ohd.hseb.hefs.utils.tools;

import com.google.common.base.Function;
import com.google.common.base.Supplier;

/**
 * Tools related go guava's {@link Supplier}.
 * 
 * @author Hank.Herr
 */
public abstract class SupplierTools
{
    /**
     * A function that calls {@link Supplier@get()}.
     */
    private static final Function<? extends Supplier<? extends Object>, Object> get;
    static
    {
        get = new Function<Supplier<? extends Object>, Object>()
        {
            @Override
            public Object apply(final Supplier<? extends Object> input)
            {
                return input.get();
            }
        };
    }

    /**
     * Creates a parameterized function that calls {@link Supplier#get()}.
     */
    @SuppressWarnings("unchecked")
    public static final <E> Function<Supplier<? extends E>, E> getFromSupplierOf(final Class<E> klass)
    {
        return (Function<Supplier<? extends E>, E>)get;
    }
}
