package ohd.hseb.hefs.utils.tools;

public abstract class ThreadTools
{
    /**
     * Wraps {@link Thread#sleep(long)} catching the exception so that sleep is stopped and nothing else is done..
     * 
     * @param millis
     */
    public static void sleep(final long millis)
    {
        try
        {
            Thread.sleep(millis);
        }
        catch(final InterruptedException e)
        {
            //Do nothing!
        }
    }
}
