package ohd.hseb.hefs.utils.topology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import ohd.hseb.hefs.utils.tools.ListTools;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;

import org.xml.sax.Attributes;

/**
 * Reads in a Topology.xml file, storing an alphabetically sorted list of the segment ids found in {@link #_segmentIds}.
 * The sorting is done in the {@link #finalizeReading()} method.
 * 
 * @author hankherr
 */
public class TopologyReader implements XMLReader
{
    private final List<String> _segmentIds = new ArrayList<>();

    public List<String> getSegmentIds()
    {
        return _segmentIds;
    }

    @Override
    public XMLReader getReader()
    {
        return this;
    }

    @Override
    public String getXMLTagName()
    {
        return "topology";
    }

    @Override
    public void setValueOfElement(final String elementName, final String value) throws XMLReaderException
    {
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(final String elementName, final Attributes attr) throws XMLReaderException
    {
        if(elementName.equals(getXMLTagName()))
        {
            _segmentIds.clear();
        }
        if(elementName.equals("node"))
        {
            final String id = attr.getValue("id");
            if(id != null)
            {
                ListTools.addItemIfNotAlreadyInList(_segmentIds, id);
            }
        }
        return null;
    }

    @Override
    public void finalizeReading() throws XMLReaderException
    {
        Collections.sort(_segmentIds);
    }

    @Override
    public void validate() throws XMLReaderException
    {
    }

}
