package ohd.hseb.hefs.utils.tsarrays;

import java.util.ArrayList;

import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;

import org.xml.sax.Attributes;

public class TimeSeriesHeaderInfoList extends ArrayList<TimeSeriesHeaderInfo> implements XMLReader
{
    private static final long serialVersionUID = 1L;

    private float _timeZoneShift = 0.0f;

    @Override
    public String toString()
    {
        String results = "TimeSeriesInformationList: ";
        for(final TimeSeriesHeaderInfo info: this)
        {
            results += "[ " + info.toString() + "];";
        }
        results += ".";
        return results;
    }

    @Override
    public String getXMLTagName()
    {
        return "TimeSeries";
    }

    @Override
    public void setValueOfElement(final String elementName, final String value) throws XMLReaderException
    {
        if(elementName.equals("timeZone"))
        {
            _timeZoneShift = Float.parseFloat(value);
        }
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(final String elementName, final Attributes attr) throws XMLReaderException
    {
        if(elementName.equals("TimeSeries"))
        {
            clear();
        }
        else if(elementName.equals("series"))
        {
            final TimeSeriesHeaderInfo newInfo = new TimeSeriesHeaderInfo();
            this.add(newInfo);
            return newInfo;
        }
        return null;
    }

    @Override
    public void finalizeReading() throws XMLReaderException
    {
        for(final TimeSeriesHeaderInfo info: this)
        {
            info.shiftTime(_timeZoneShift);
        }
    }

    @Override
    public void validate() throws XMLReaderException
    {
    }

    @Override
    public XMLReader getReader()
    {
        return this;
    }
}
