package ohd.hseb.hefs.utils.tsarrays.agg;

import ohd.hseb.hefs.utils.xml.vars.XMLTimeStep;

/**
 * Implementation of XMLTimeStep that uses the {@link XMLTimeStep#PERIOD_SPECIAL_UNITS} special units.
 * 
 * @author Hank.Herr
 */
public class ComputationTimeStep extends XMLTimeStep
{
    public ComputationTimeStep()
    {
        super(XMLTimeStep.PERIOD_SPECIAL_UNITS);
    }

    public ComputationTimeStep(final String xmlTag)
    {
        super(xmlTag, XMLTimeStep.PERIOD_SPECIAL_UNITS);
    }

    public ComputationTimeStep(final String xmlTag, final String unit, final int multiplier)
    {
        super(xmlTag, unit, multiplier, XMLTimeStep.PERIOD_SPECIAL_UNITS);
    }

    /**
     * @return True if this time step uses a 'period' unit (in which case the multiplier/quantity is ignored).
     */
    public boolean isPeriod()
    {
        return getUnit().equals(XMLTimeStep.PERIOD_UNIT);
    }

}
