package ohd.hseb.hefs.utils.tsarrays.agg;

/**
 * Instantaneous aggregation that implements the {@link OHDAggregator}. This value gets the value at the end time of the
 * aggregation period being aggregated over. It does not make a lot of sense for this aggregator to be used in
 * conjunction with a {@link PeriodAnchor} of {@link AnchorsEnum#centered}.
 * 
 * @author Hank.Herr
 */
public class InstantaneousAggregator extends OHDAggregator
{
    @Override
    public float aggregate() throws TimeSeriesAggregationException
    {
        //This one will look for the best value to use, even if the period is not completely covered with data.  If the 
        //input count is 0 or less or not affected window includes the desired time, THEN it will return NaN.

        // Find the window that contains the desired computation time. Usually the computation time
        // is the end time of the working period (getInputCount()-1), so a loop from the 
        // end is used, but it could be in the middle, and an Arrays.binarySearch might be more efficient.
        // If you can't find a window that contains the computation time, return NaN.

        for(int i = getInputCount() - 1; i > -1; i--)
        {
            if(getInputAffectedWindow(i).contains(getComputationTime()))
            {
                return getInputValue(i);
            }
        }

        return Float.NaN;
    }

    @Override
    public String getAggregationDisplayName()
    {
        return "instantaneous";
    }
}