package ohd.hseb.hefs.utils.tsarrays.agg;

import nl.wldelft.util.Period;
import ohd.hseb.hefs.utils.xml.vars.XMLEnum;

/**
 * An {@link XMLEnum} that wraps {@link AnchorsEnum}.
 * 
 * @author Hank.Herr
 */
public class PeriodAnchor extends XMLEnum<AnchorsEnum>
{

    public PeriodAnchor()
    {
        super(AnchorsEnum.class, "unspecifiedTag", AnchorsEnum.ending);
    }

    public PeriodAnchor(final String tag)
    {
        super(AnchorsEnum.class, tag, AnchorsEnum.ending);
    }

    public PeriodAnchor(final String tag, final AnchorsEnum initialValue)
    {
        super(AnchorsEnum.class, tag, initialValue);
    }

    /**
     * @return The anchor time to use for the period with the provided start and end time in millis. For centered, the
     *         recording time is the exact mid point between the two.
     */
    public long computeAnchorTime(final long periodStart, final long periodEnd)
    {
        if(isEnding())
        {
            return periodEnd;
        }

        //Centered is the average of the two.
        return (long)((periodEnd + periodStart) / 2D);
    }

    /**
     * @return As {@link #computeAnchorTime(long, long)}, but pulls the start and end from the provided period.
     */
    public long computeAnchorTime(final Period period)
    {
        return computeAnchorTime(period.getStartTime(), period.getEndTime());
    }

    public boolean isCentered()
    {
        return get().equals(AnchorsEnum.centered);
    }

    public boolean isEnding()
    {
        return get().equals(AnchorsEnum.ending);
    }
}