package ohd.hseb.hefs.utils.xml;

import java.util.ArrayList;
import java.util.Collection;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CollectionXMLWriter extends XMLWriterAdapter
{
    private final Collection<? extends XMLWriter> _backingCollection;

    @SuppressWarnings({"rawtypes", "unchecked"})
    public CollectionXMLWriter(final String tagName, final Collection<? extends XMLWritable> collection)
    {
        super(tagName);
        _tagName = tagName;
        _backingCollection = new ArrayList<XMLWriter>(collection.size());
        for(final XMLWritable writable: collection)
        {
            ((ArrayList)_backingCollection).add(writable.getWriter());
        }
    }

    @Override
    public Element writePropertyToXMLElement(final Document request) throws XMLWriterException
    {
        final Element mainElt = super.writePropertyToXMLElement(request);
        for(final XMLWriter item: _backingCollection)
        {
            final Element subElt = item.writePropertyToXMLElement(request);
            mainElt.appendChild(subElt);
        }
        return mainElt;
    }
}
