package ohd.hseb.hefs.utils.xml;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import org.xml.sax.Attributes;

import ohd.hseb.hefs.utils.effect.Effect;

/**
 * Using a factory, this reads in a list of xml tags under a specified tag, and then passes a list of the read objects
 * to a specified callback.
 * 
 * @author alexander.garbarino
 * @param <A> The {@link XMLReadable} element that will be read for the list.
 */
public class ListXMLReader<A extends XMLReadable> extends XMLReaderAdapter
{
    private final XMLReaderFactory<A> _factory;
    private final Effect<List<A>> _callback;

    private final List<A> _items;
    private A _temp;
    private XMLReader _tempReader;

    public ListXMLReader(final String tagName,
                         final XMLReaderFactory<A> factory,
                         final Effect<List<A>> finalizeCallback)
    {
        super(tagName);

        _factory = factory;
        _callback = finalizeCallback;

        _items = newArrayList();
        _temp = _factory.get();
        _tempReader = _temp.getReader();
    }
    
    /**
     * 
     * @return The size of the underlying list.
     */
    public int size()
    {
        return _items.size();
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(final String elementName,
                                                  final Attributes attr) throws XMLReaderException
    {
        super.readInPropertyFromXMLElement(elementName, attr);
        if(elementName.equals(getXMLTagName()))
        {
            _items.clear();
        }
        try
        {
            if(_tempReader.getXMLTagName().equals(elementName))
            {
                final XMLReader reader = _tempReader;
                _items.add(_temp);
                _temp = _factory.get();
                _tempReader = _temp.getReader();
                return reader;
            }
        }
        catch(final NullPointerException e)
        {
            throw new XMLReaderException("List [" + getXMLTagName() + "] incorrectly formed.", e);
        }
        return null;
    }

    @Override
    public void finalizeReading() throws XMLReaderException
    {
        super.finalizeReading();
        if(_callback != null)
        {
            _callback.perform(_items);
        }
    }
}
