package ohd.hseb.hefs.utils.xml;

import java.util.Map;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * Writes values from a map to xml. The key and value of the map should each have a no argument constructor to be read
 * back in with.
 * 
 * @author alexander.garbarino
 */
public class MapXMLWriter extends XMLWriterAdapter
{
    private final Map<? extends XMLWriter, ? extends XMLWriter> _backingMap;

    public MapXMLWriter(String tagName, Map<? extends XMLWriter, ? extends XMLWriter> data)
    {
        super(tagName);
        _backingMap = data;
    }

    @Override
    public Element writePropertyToXMLElement(Document request) throws XMLWriterException
    {
        Element elt = super.writePropertyToXMLElement(request);
        for(Map.Entry<? extends XMLWriter, ? extends XMLWriter> entry: _backingMap.entrySet())
        {
            Element entryElt = request.createElement("mapEntry");

            Element keyElt = entry.getKey().writePropertyToXMLElement(request);
            keyElt.setAttribute("mapEntryPosition", "key");
            entryElt.appendChild(keyElt);

            Element valElt = entry.getValue().writePropertyToXMLElement(request);
            valElt.setAttribute("mapEntryPosition", "value");
            entryElt.appendChild(valElt);

            elt.appendChild(entryElt);
        }

        return elt;
    }

}
