package ohd.hseb.hefs.utils.xml;

import ohd.hseb.hefs.utils.xml.vars.XMLDouble;
import ohd.hseb.hefs.utils.xml.vars.XMLString;

/**
 * Used if you don't implement XMLReader yourself, but you can create a reader on demand.<br>
 * <br>
 * Recommended Usage: Create a class meant to store parameters, options, or anything else that will find its way into
 * XML. Use the {@link XMLVariable} subclasses to store the attributes/values in your class; examples: {@link XMLString}
 * , {@link XMLDouble}, etc. Decide which of those will be read/written to XML as elements and which as attributes. In
 * the {@link #getReader()} method, instantiate the appropriate implementation of XMLReadable, probably
 * {@link CompositeXMLReader}, but maybe {@link CollectionXMLReader}, {@link MapXMLReader}, or {@link ListXMLReader}.
 * Pass in the element XMLVariables to the constructor and add the attributes via method calls; example
 * {@link XMLReaderAdapter#addAttribute(String, XMLVariable, boolean)}.
 * 
 * @author alexander.garbarino
 * @author Hank.Herr
 */
public interface XMLReadable
{
    /**
     * Create a reader for this object. The created reader should update this object as it reads. If this object also
     * implements XMLReader, then it can just return itself.
     * 
     * @return a reader for this object
     */
    public XMLReader getReader();
}
