package ohd.hseb.hefs.utils.xml;

import org.xml.sax.Attributes;

/**
 * This class wraps an {@link XMLReader}, passing calls to methods to the wrapped reader. This is useful if there is
 * finalization in one class that must occur based on another object's results of reading.
 * 
 * @author hank.herr
 */
public class XMLReaderWrapper implements XMLReader
{

    private final XMLReader _wrappedReader;

    public XMLReaderWrapper(final XMLReader wrappedReader)
    {
        _wrappedReader = wrappedReader;
    }

    public XMLReader getWrappedReader()
    {
        return _wrappedReader;
    }

    @Override
    public XMLReader getReader()
    {
        return this;
    }

    @Override
    public String getXMLTagName()
    {
        return _wrappedReader.getXMLTagName();
    }

    @Override
    public void setValueOfElement(final String elementName, final String value) throws XMLReaderException
    {
        _wrappedReader.setValueOfElement(elementName, value);
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(final String elementName, final Attributes attr) throws XMLReaderException
    {
        return _wrappedReader.readInPropertyFromXMLElement(elementName, attr);
    }

    @Override
    public void finalizeReading() throws XMLReaderException
    {
        _wrappedReader.finalizeReading();
    }

    @Override
    public void validate() throws XMLReaderException
    {
        _wrappedReader.validate();
    }
}
