package ohd.hseb.hefs.utils.xml;

import javax.xml.stream.XMLStreamWriter;

/**
 * If an {@link XMLWriter} implements this, then it is able to directly write to an {@link XMLStreamWriter}. Implement
 * this in cases where there is a large amount of data involved, such as {@link TableXMLWriter} and
 * {@link ArrayXMLWriter} to avoid heap space error.<br>
 * <br>
 * This interface extends {@link XMLWriter} in order to enforce the rule that any {@link XMLStreamWriterWriter} MUST
 * also implement {@link XMLWriter}. This is because it is not always the case that XML writing will use the
 * {@link XMLStreamWriterWriter}; sometimes it will call the {@link XMLWriter} method.
 * 
 * @author hank.herr
 */
public interface XMLStreamWriterWriter extends XMLWriter
{
    public void writeXML(XMLStreamWriter streamWriter) throws Exception;

}
