package ohd.hseb.hefs.utils.xml;

/**
 * Used if you don't implement XMLWriter yourself, but can create a writer on demand.
 * 
 * @author alexander.garbarino
 */
public interface XMLWritable
{
    /**
     * Create a writer backed by this object. If this object implements {@link XMLWriter}, then it can just return
     * itself. This method should never return null.
     * 
     * @return a writer for this object. Null is allowed; null writers are ignored.
     */
    public XMLWriter getWriter();
}
