package ohd.hseb.hefs.utils.xml;

import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * Implement this if the object is to output XML via a DOM {@link Document} and {@link Transformer}.<br>
 * <br>
 * Note that for large amounts of data, using this {@link XMLWriter} can be slow and cause heap space issues. In such
 * cases, the {@link XMLWriter} should also implement {@link XMLStreamWriterWriter}. By writing directly to an
 * {@link XMLStreamWriter} much time and memory can be saved. For example, writing MEFP parameters to an fi.gz file went
 * from taking 80+ seconds to 17 seconds.<br>
 * <br>
 * Note that every {@link XMLWriter} is also {@link XMLWritable}, usually by returning this for
 * {@link XMLWritable#getWriter()}.
 * 
 * @author hank.herr
 */
public interface XMLWriter extends XMLWritable
{
    /**
     * @return The tag name of the element this writer will write.
     */
    public String getXMLTagName();

    /**
     * Creates a single DOM {@link Element} summarizing the settings in this {@link XMLWriter}.
     * 
     * @param request A {@link Document} from which to construct elements.
     * @return {@link Element} instances that will output this {@link XMLWriterException} to an XML file.
     */
    public Element writePropertyToXMLElement(Document request) throws XMLWriterException;
}
