package ohd.hseb.hefs.utils.xml.vars;

import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLVariable;

public class XMLBoolean extends XMLVariable<Boolean>
{
    private static final String DEFAULT_TAG = "boolean";

    public XMLBoolean()
    {
        super(DEFAULT_TAG);
    }

    public XMLBoolean(String tag)
    {
        super(tag);
    }

    public XMLBoolean(Boolean value)
    {
        super(DEFAULT_TAG, value);
    }

    public XMLBoolean(String tag, Boolean value)
    {
        super(tag, value);
    }

    @Override
    protected Boolean readVariable(String text) throws XMLReaderException
    {
        try
        {
            return Boolean.valueOf(text);
        }
        catch(NumberFormatException e)
        {
            throw new XMLReaderException(this.getXMLTagName() + " value, '" + text + "', is not true or false.");
        }
    }
}
