package ohd.hseb.hefs.utils.xml.vars;

import java.awt.Color;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

import com.google.common.base.Objects;

import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLTools;
import ohd.hseb.hefs.utils.xml.XMLToolsException;
import ohd.hseb.hefs.utils.xml.XMLVariable;
import ohd.hseb.hefs.utils.xml.XMLWriterException;

/**
 * This {@link XMLVariable} CANNOT carry around extra attributes. It must have exactly four attributes: red, blue,
 * green, and alpha. Any added attributes are ignored. This uses {@link XMLTools} color methods to read and write
 * colors.
 * 
 * @author hank.herr
 */
public class XMLColor extends XMLVariable<Color>
{
    public static final String DEFAULT_TAG = "color";

    public XMLColor()
    {
        super(DEFAULT_TAG);
    }

    public XMLColor(final String tag)
    {
        super(tag);
    }

    public XMLColor(final Color value)
    {
        super(DEFAULT_TAG, value);
    }

    public XMLColor(final String tag, final Color value)
    {
        super(tag, value);
    }

    @Override
    public Element writePropertyToXMLElement(final Document request) throws XMLWriterException
    {
        return XMLTools.createColorElement(getXMLTagName(), request, this.get());
    }

    @Override
    protected String writeVariable(final Color value)
    {
        return null; //THIS SHOULD NEVER BE CALLED BECAUSE I OVERWROTE writePropertyToXMLElement
    }

    @Override
    protected Color readVariable(final String text) throws XMLReaderException
    {
        return null; //THIS SHOULD NEVER BE CALLED BECAUSE I OVERWRITE setValueOfElement
    }

    @Override
    public void setValueOfElement(final String elementName, final String value) throws XMLReaderException
    {
        //DO NOTHING... processing is handled via readInPropertyFromXMLElement.
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(final String elementName,
                                                  final Attributes attr) throws XMLReaderException
    {
        //Its easier to use the XMLTools static method than setup attributes to contains the rgba values and
        //process them.  Hence, I've overridden the readInPropertyFromXMLElement method here.
        if(Objects.equal(getXMLTagName(), elementName))
        {
            try
            {
                set(XMLTools.extractColorFromAttributes(attr));
            }
            catch(final XMLToolsException e)
            {
                throw new XMLReaderException("XML color is invalid: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public XMLColor clone()
    {
        return (XMLColor)super.clone();
    }
}
