package ohd.hseb.hefs.utils.xml.vars;

import ohd.hseb.hefs.utils.AbstractFunction;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLReaderFactory;

public class XMLDouble extends XMLNumber<Double>
{
    private static final String DEFAULT_TAG = "double";

    public XMLDouble()
    {
        super(DEFAULT_TAG);
    }

    public XMLDouble(final String tag)
    {
        super(tag);
    }

    public XMLDouble(final Double value)
    {
        super(DEFAULT_TAG, value);
    }

    public XMLDouble(final String tag, final Double value)
    {
        super(tag, value);
    }

    public XMLDouble(final String tag, final Double value, final Double lowerBound, final Double upperBound)
    {
        super(tag, value);
        this.setBounds(lowerBound, upperBound);
    }

    @Override
    protected Double readVariable(final String text) throws XMLReaderException
    {
        try
        {
            final Double value = Double.valueOf(text);
            checkBounds(value);
            return value;
        }
        catch(final NumberFormatException e)
        {
            throw new XMLReaderException(this.getXMLTagName() + " value, '" + text + "', is not a number.");
        }
    }

    public static XMLReaderFactory<XMLDouble> makeFactory(final String tagName)
    {
        return new XMLReaderFactory<XMLDouble>()
        {
            @Override
            public XMLDouble get()
            {
                return new XMLDouble(tagName);
            }
        };
    }

    /**
     * A function that wraps doubles in an XMLDouble with the given tag name.
     * 
     * @param tagName the tag name to use
     */
    public static AbstractFunction<Double, XMLDouble> wrapFunction(final String tagName)
    {
        return new AbstractFunction<Double, XMLDouble>()
        {
            @Override
            public XMLDouble apply(final Double input)
            {
                return new XMLDouble(tagName, input);
            }
        };
    }
}
