package ohd.hseb.hefs.utils.xml.vars;

import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLVariable;

/**
 * {@link XMLVariable} type that makes use of an Enumeration.
 * 
 * @author hankherr
 * @param <T> The enumeration being used.
 */
public class XMLEnum<T extends Enum<T>> extends XMLVariable<T>
{
    private final Class<T> _class;

    public XMLEnum(final Class<T> klass, final String tag)
    {
        super(tag);
        _class = klass;
    }

    public XMLEnum(final Class<T> klass, final String tag, final T value)
    {
        super(tag, value);
        _class = klass;
    }

    @Override
    protected T readVariable(final String text) throws XMLReaderException
    {
        try
        {
            return Enum.valueOf(_class, text);
        }
        catch(final IllegalArgumentException e)
        {
            throw new XMLReaderException(this.getXMLTagName() + " value, '" + text + "', is not a valid choice.");
        }
    }
}
