package ohd.hseb.hefs.utils.xml.vars;

import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLReaderFactory;

public class XMLFloat extends XMLNumber<Float>
{
    public static final String DEFAULT_TAG = "float";

    public XMLFloat()
    {
        super(DEFAULT_TAG);
    }

    public XMLFloat(final String tag)
    {
        super(tag);
    }

    public XMLFloat(final Float value)
    {
        super(DEFAULT_TAG, value);
    }

    public XMLFloat(final String tag, final Float value)
    {
        super(tag, value);
    }

    @Override
    protected Float readVariable(final String text) throws XMLReaderException
    {
        try
        {
            final Float value = Float.valueOf(text);
            checkBounds(value);
            return value;
        }
        catch(final NumberFormatException e)
        {
            throw new XMLReaderException(this.getXMLTagName() + " value, '" + text + "', is not a number.");
        }
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    @Override
    public XMLReaderFactory<XMLFloat> makeCloneFactory()
    {
        return (XMLReaderFactory)super.makeCloneFactory();
    }

    @Override
    public XMLFloat clone()
    {
        return (XMLFloat)super.clone();
    }
}
