package ohd.hseb.hefs.utils.xml.vars;

import java.awt.Font;

import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLTools;
import ohd.hseb.hefs.utils.xml.XMLToolsException;
import ohd.hseb.hefs.utils.xml.XMLVariable;
import ohd.hseb.hefs.utils.xml.XMLWriterException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

import com.google.common.base.Objects;

/**
 * This {@link XMLVariable} CANNOT carry around extra attributes. It must have exactly four attributes: red, blue,
 * green, and alpha. Any added attributes are ignored. This uses {@link XMLTools} font methods to read and write fonts.
 * 
 * @author hank.herr
 */
public class XMLFont extends XMLVariable<Font>
{
    public static final String DEFAULT_TAG = "Font";

    public XMLFont()
    {
        super(DEFAULT_TAG);
    }

    public XMLFont(String tag)
    {
        super(tag);
    }

    public XMLFont(Font value)
    {
        super(DEFAULT_TAG, value);
    }

    public XMLFont(String tag, Font value)
    {
        super(tag, value);
    }

    @Override
    public Element writePropertyToXMLElement(Document request) throws XMLWriterException
    {
        return XMLTools.createFontElement(getXMLTagName(), request, this.get());
    }

    @Override
    protected String writeVariable(Font value)
    {
        return null; //THIS SHOULD NEVER BE CALLED BECAUSE I OVERWROTE writePropertyToXMLElement
    }

    @Override
    protected Font readVariable(String text) throws XMLReaderException
    {
        return null; //THIS SHOULD NEVER BE CALLED BECAUSE I OVERWRITE setValueOfElement
    }

    @Override
    public void setValueOfElement(String elementName, String value) throws XMLReaderException
    {
        //DO NOTHING... processing is handled via readInPropertyFromXMLElement.
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(String elementName, Attributes attr) throws XMLReaderException
    {
        //Its easier to use the XMLTools static method than setup attributes to contains the rgba values and
        //process them.  Hence, I've overridden the readInPropertyFromXMLElement method here.
        if(Objects.equal(getXMLTagName(), elementName))
        {
            try
            {
                set(XMLTools.extractFontFromAttributes(attr));
            }
            catch(XMLToolsException e)
            {
                throw new XMLReaderException("XML font is invalid: " + e.getMessage());
            }
        }
        return null;
    }

}
