package ohd.hseb.hefs.utils.xml.vars;

import ohd.hseb.hefs.utils.collect.Grouping;
import ohd.hseb.hefs.utils.xml.XMLVariable;

/**
 * This could be extended to take a factory for read in elements, but for now it will only read/write the actual
 * grouping and assume you know the elements ahead of time.
 * 
 * @author alexander.garbarino
 * @param <E> the type of element.
 */
public class XMLGrouping<E extends Enum<E>> extends XMLVariable<Grouping<E>>
{
    public XMLGrouping(final String tag, final Class<E> enumClass)
    {
        super(tag, Grouping.create(enumClass));
    }

    public XMLGrouping(final String tag, final Grouping<E> grouping)
    {
        super(tag, grouping);
    }

    @Override
    protected String writeVariable(final Grouping<E> value)
    {
        return value.toString();
    }

    @Override
    protected Grouping<E> readVariable(final String text)
    {
        final Grouping<E> grouping = get();
        grouping.setToString(text);
        return grouping;
    }

    @Override
    public XMLGrouping clone()
    {
        return (XMLGrouping)super.clone();
    }
}
