package ohd.hseb.hefs.utils.xml.vars;

import ohd.hseb.hefs.utils.xml.XMLReaderException;

/**
 * A decorator for an {@link Integer} which lets it be read from / written to xml.
 * 
 * @author alexander.garbarino
 */
public class XMLInteger extends XMLNumber<Integer>
{
    public static final String DEFAULT_TAG = "integer";

    public XMLInteger()
    {
        super(DEFAULT_TAG);
    }

    public XMLInteger(final String tag)
    {
        super(tag);
    }

    public XMLInteger(final Integer value)
    {
        super(DEFAULT_TAG, value);
    }

    public XMLInteger(final String tag, final Integer value)
    {
        super(tag, value);
    }

    public XMLInteger(final String tag, final Integer lb, final Integer ub)
    {
        super(tag);
        setBounds(lb, ub);
    }

    public XMLInteger(final Integer value, final Integer lb, final Integer ub)
    {
        super(DEFAULT_TAG, value);
        setBounds(lb, ub);
    }

    public XMLInteger(final String tag, final Integer value, final Integer lb, final Integer ub)
    {
        super(tag, value);
        setBounds(lb, ub);
    }

    @Override
    protected Integer readVariable(final String text) throws XMLReaderException
    {
        try
        {
            final Integer value = Integer.valueOf(text);
            checkBounds(value);
            return value;
        }
        catch(final NumberFormatException e)
        {
            throw new XMLReaderException(this.getXMLTagName() + " value, '" + text + "', is not an integer.");
        }
    }

    @Override
    public XMLInteger clone()
    {
        return (XMLInteger)super.clone();
    }
}
