package ohd.hseb.hefs.utils.xml.vars;

import java.util.ArrayList;
import java.util.Collections;

import ohd.hseb.hefs.utils.notify.collect.NotifyingList;
import ohd.hseb.hefs.utils.notify.collect.NotifyingListWrapper;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLVariable;

public class XMLListChoice extends XMLVariable<String>
{
    public static final String DEFAULT_TAG = "listChoice";

    private final NotifyingList<String> _choices = NotifyingListWrapper.wrap(new ArrayList<String>());

    public XMLListChoice(final String[] choices)
    {
        super(DEFAULT_TAG);
//        this.subscribe(_choices);  Commented out because I don't want EventBuses being created each time a list choice is constructed
        setList(choices);
    }

    public XMLListChoice(final String tag, final String[] choices)
    {
        super(tag);
//        this.subscribe(_choices);  Commented out because I don't want EventBuses being created each time a list choice is constructed
        setList(choices);
    }

    public XMLListChoice(final String tag, final String value, final String[] choices)
    {
        super(tag);
//        this.subscribe(_choices);  Commented out because I don't want EventBuses being created each time a list choice is constructed
        setList(choices);
        set(value);
    }

    /**
     * Whenever something else is registered to listen to events posted by this object, only then should this be
     * subscribed to {@link #_choices} in order to forward notices from {@link #_choices} to the registered objects.
     */
    @Override
    public void register(final Object object)
    {
        this.subscribe(_choices);
        super.register(object);
    }

    public void setList(final String[] choices)
    {
        _choices.clear();
        Collections.addAll(_choices, choices);
    }

    public NotifyingList<String> getChoices()
    {
        return _choices;
    }

    @Override
    public void set(final String value, final Object source)
    {
        if((value != null) && (!_choices.contains(value)))
        {
            throw new IllegalArgumentException("Value '" + value + "' is not a valid choice.");
        }
        super.set(value, source);
    }

    @Override
    protected String readVariable(final String text) throws XMLReaderException
    {
        if(!_choices.contains(text))
        {
            throw new XMLReaderException("Value '" + text + "' is not a valid choice.");
        }
        return text;
    }

}
