package ohd.hseb.hefs.utils.xml.vars;

import ohd.hseb.hefs.utils.xml.XMLReaderException;

/**
 * A decorator for an {@link Integer} which lets it be read from / written to xml.
 * 
 * @author alexander.garbarino
 */
public class XMLLong extends XMLNumber<Long>
{
    public static final String DEFAULT_TAG = "long";

    public XMLLong()
    {
        super(DEFAULT_TAG);
    }

    public XMLLong(final String tag)
    {
        super(tag);
    }

    public XMLLong(final Long value)
    {
        super(DEFAULT_TAG, value);
    }

    public XMLLong(final String tag, final Long value)
    {
        super(tag, value);
    }

    public XMLLong(final String tag, final Long lb, final Long ub)
    {
        super(tag);
        setBounds(lb, ub);
    }

    public XMLLong(final Long value, final Long lb, final Long ub)
    {
        super(DEFAULT_TAG, value);
        setBounds(lb, ub);
    }

    public XMLLong(final String tag, final Long value, final Long lb, final Long ub)
    {
        super(tag, value);
        setBounds(lb, ub);
    }

    @Override
    protected Long readVariable(final String text) throws XMLReaderException
    {
        try
        {
            final Long value = Long.valueOf(text);
            checkBounds(value);
            return value;
        }
        catch(final NumberFormatException e)
        {
            throw new XMLReaderException(this.getXMLTagName() + " value, '" + text + "', is not an integer.");
        }
    }
}
