package ohd.hseb.hefs.utils.xml.vars;

import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLReaderFactory;
import ohd.hseb.hefs.utils.xml.XMLVariable;
import ohd.hseb.measurement.MeasuringUnit;

/**
 * An XMLReader/Writer interface to strings.
 * 
 * @author alexander.garbarino
 */
public class XMLMeasuringUnit extends XMLVariable<MeasuringUnit>
{
    public static final String DEFAULT_TAG = "unit";

    public XMLMeasuringUnit()
    {
        super(DEFAULT_TAG);
    }

    public XMLMeasuringUnit(final String tag)
    {
        super(tag);
    }

    public XMLMeasuringUnit(final String tag, final MeasuringUnit value)
    {
        super(tag, value);
    }

    public static XMLReaderFactory<XMLMeasuringUnit> makeFactory()
    {
        return makeFactory(DEFAULT_TAG);
    }

    /**
     * Makes a factory creating blank strings with the given tag.
     * 
     * @param tag the tag to assign new strings
     * @return a factory to create strings with the given tag
     */
    @SuppressWarnings({"unchecked", "rawtypes"})
    public static XMLReaderFactory<XMLMeasuringUnit> makeFactory(final String tag)
    {
        return (XMLReaderFactory)new XMLMeasuringUnit(tag).makeCloneFactory();
    }

    @Override
    protected MeasuringUnit readVariable(final String text) throws XMLReaderException
    {
        final MeasuringUnit unit = MeasuringUnit.getMeasuringUnit(text);
        if(unit == null)
        {
            throw new XMLReaderException(this.getXMLTagName() + " value, '" + text
                + "', is not an acceptable measuring unit.");
        }
        return unit;
    }
}
