package ohd.hseb.hefs.utils.xml.vars;

import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLVariable;

/**
 * Like {@link XMLBoolean}, but writes on/off instead of true/false.
 * 
 * @author alexander.garbarino
 */
public class XMLOnOffBoolean extends XMLVariable<Boolean>
{
    private static final String DEFAULT_TAG = "onoff";

    public XMLOnOffBoolean()
    {
        super(DEFAULT_TAG);
    }

    public XMLOnOffBoolean(String tag)
    {
        super(tag);
    }

    public XMLOnOffBoolean(Boolean value)
    {
        super(DEFAULT_TAG, value);
    }

    public XMLOnOffBoolean(String tag, Boolean value)
    {
        super(tag, value);
    }

    @Override
    protected Boolean readVariable(String text) throws XMLReaderException
    {
        if("on".equals(text))
        {
            return true;
        }
        else if("off".equals(text))
        {
            return false;
        }
        throw new XMLReaderException(String.format("\"%s\" is not \"on\" or \"off\".", text));
    }

    @Override
    protected String writeVariable(Boolean value)
    {
        return value ? "on" : "off";
    }
}
