package ohd.hseb.hefs.utils.xml.vars;

import java.util.List;

import ohd.hseb.hefs.utils.xml.XMLReaderFactory;
import ohd.hseb.hefs.utils.xml.XMLVariable;

import com.google.common.collect.Lists;

/**
 * An XMLReader/Writer interface to strings.
 * 
 * @author alexander.garbarino
 */
public class XMLString extends XMLVariable<String>
{
    public static final String DEFAULT_TAG = "string";

    public XMLString()
    {
        super(DEFAULT_TAG);
    }

    public XMLString(final String tag)
    {
        super(tag);
    }

    public XMLString(final String tag, final String value)
    {
        super(tag, value);
    }

    public static XMLReaderFactory<XMLString> makeFactory()
    {
        return makeFactory(DEFAULT_TAG);
    }

    /**
     * Makes a factory creating blank strings with the given tag.
     * 
     * @param tag the tag to assign new strings
     * @return a factory to create strings with the given tag
     */
    @SuppressWarnings({"unchecked", "rawtypes"})
    public static XMLReaderFactory<XMLString> makeFactory(final String tag)
    {
        return (XMLReaderFactory)new XMLString(tag).makeCloneFactory();
    }

    @Override
    protected String readVariable(final String text)
    {
        return text;
    }

    /**
     * @return An {@link XMLString} with the given tag and initial value.
     */
    public static XMLString convertString(final String tag, final String value)
    {
        return new XMLString(tag, value);
    }

    /**
     * @param values The {@link String} instances to convert.
     * @return A {@link List} of {@link XMLString} instances, one for each provided value. Each has the given tag name.
     */
    public static List<XMLString> convertList(final String tag, final Iterable<String> values)
    {
        final List<XMLString> results = Lists.newArrayList();
        for(final String value: values)
        {
            results.add(convertString(tag, value));
        }
        return results;
    }
}
