package ohd.hseb.hefs.utils.xml.vars;

import java.util.TimeZone;

import ohd.hseb.hefs.utils.datetime.HEFSTimeZoneTools;

/**
 * The {@link TimeZone} is stored based on {@link TimeZone#getID()}. Call methods {@link #getAsTimeZone()} and
 * {@link #setAsTimeZone(TimeZone)} to go to and from TimeZone instances. A list of valid choices is provided by
 * {@link HEFSTimeZoneTools#getValidTimeZoneIdentifiersIncludingSeparators()}.
 * 
 * @author hank.herr
 */
public class XMLTimeZone extends XMLListChoice
{
    public static final String DEFAULT_TAG = "timeZone";

    public XMLTimeZone()
    {
        super(HEFSTimeZoneTools.getValidTimeZoneIdentifiersIncludingSeparators().toArray(new String[1]));
    }

    public XMLTimeZone(String tag)
    {
        super(tag, HEFSTimeZoneTools.getValidTimeZoneIdentifiersIncludingSeparators().toArray(new String[1]));
    }

    public XMLTimeZone(String tag, String value)
    {
        super(tag, value, HEFSTimeZoneTools.getValidTimeZoneIdentifiersIncludingSeparators().toArray(new String[1]));
    }

    public TimeZone getAsTimeZone()
    {
        return HEFSTimeZoneTools.retrieveTimeZone(this.get());
    }

    public void setAsTimeZone(TimeZone tz)
    {
        set(tz.getID());
    }
}
