package ohd.hseb.hefs.utils.xml.vars;

import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLVariable;

/**
 * Like {@link XMLBoolean}, but writes on/off instead of true/false.
 * 
 * @author alexander.garbarino
 */
public class XMLYesNoBoolean extends XMLVariable<Boolean>
{
    private static final String DEFAULT_TAG = "yesno";

    public XMLYesNoBoolean()
    {
        super(DEFAULT_TAG);
    }

    public XMLYesNoBoolean(String tag)
    {
        super(tag);
    }

    public XMLYesNoBoolean(Boolean value)
    {
        super(DEFAULT_TAG, value);
    }

    public XMLYesNoBoolean(String tag, Boolean value)
    {
        super(tag, value);
    }

    @Override
    protected Boolean readVariable(String text) throws XMLReaderException
    {
        if("yes".equals(text))
        {
            return true;
        }
        else if("no".equals(text))
        {
            return false;
        }
        throw new XMLReaderException(String.format("\"%s\" is neither \"yes\" or \"no\".", text));
    }

    @Override
    protected String writeVariable(Boolean value)
    {
        return value ? "yes" : "no";
    }
}
